/**
 * @customElement
 * @polymer
 */
class PlanarCard extends Polymer.Element {
  static get is() { return 'planar-card'; }
  
  static get properties() {
    return {
      hasCard: {
        type: Boolean,
        computed: 'computeHasCard_(card)',
        readOnly: true,
      },
      card: Object,
      counter: Number,
    };
  }
  
  constructor() {
    super();
    this.addedChaoticAether_ = false;
  }
  
  computeHasCard_(card) {
    return !!card;
  }
  
  setCard(card) {
    if (this.card && this.card.listeners) {
      for (const event of Object.keys(this.card.listeners)) {
        switch (event) {
          case 'tap':
            this.removeEventListener('tap', this[this.card.listeners[event]]);
            break;
          case 'rolled-chaos':
            this.removeEventListener('rolled-chaos',
                this[this.card.listeners[event]]);
            break;
        }
      }
    }
    if (this.card && this.card.isPhenomenon) {
      this.removeEventListener('tap', this.planeswalk);
    }
    
    this.card = card;
    this.counter = 0;
    if (card && card.listeners) {
      for (const event of Object.keys(card.listeners)) {
        switch (event) {
          case 'tap':
            this.addEventListener('tap', this[card.listeners[event]]);
            break;
          case 'rolled-chaos':
            this.addEventListener('rolled-chaos', this[card.listeners[event]]);
            break;
          case 'rolled-planeswalk':
            this[card.listeners[event]](true);
            if (!this.addedChaoticAether_) {
              this.addedChaoticAether_ = true;
              this.addEventListener('rolled-planeswalk',
                  this[card.listeners[event]]);
            }
            break;
          case 'encountered':
            this[card.listeners[event]]();
            break;
        }
      }
    }
    if (card && card.isPhenomenon) {
      this.addEventListener('tap', this.planeswalk);
    }
    
    if (card && card.text) {
      setTimeout(() => {
        const tooltip = this.shadowRoot.querySelector('paper-tooltip');
        tooltip.innerHTML = card.text
          .replace('\n', '<br>')
          .replace(/\{CHAOS\}/g, '<img src="/images/chaos-white.png" class="chaos">')
          .replace(/\{(\d|[WUBRGTX])\}/g,
              '<img src="/images/mana/$1.svg" class="mana">');
      });
    }
  }
  
  planeswalk() {
    this.dispatchEvent(new CustomEvent('trigger-planeswalk', {
      bubbles: true,
      composed: true,
    }));
  }
  
  incrementCounter() {
    this.counter++;
  }
  
  poolsOfBecomingChaos() {
    this.dispatchEvent(new CustomEvent('pools-of-becoming', {
      bubbles: true,
      composed: true,
    }));
  }
  
  chaoticAetherEffects(enable) {
    if (typeof enable === 'boolean' && enable) {
      this.dispatchEvent(new CustomEvent('encounter-chaotic-aether', {
        bubbles: true,
        composed: true,
      }));
    } else {
      this.dispatchEvent(new CustomEvent('end-chaotic-aether', {
        bubbles: true,
        composed: true,
      }));
    }
  }
  
  interplanarTunnelEffects() {
    this.dispatchEvent(new CustomEvent('interplanar-tunnel', {
      bubbles: true,
      composed: true,
    }));
  }
  
  stairsToInfinityChaos() {
  }
}

window.customElements.define(PlanarCard.is, PlanarCard);