-- phpMyAdmin SQL Dump
-- version 3.4.11.1deb2+deb7u2
-- http://www.phpmyadmin.net
--
-- Host: 127.0.0.1
-- Generation Time: May 16, 2016 at 01:15 PM
-- Server version: 5.7.11
-- PHP Version: 5.4.45-0+deb7u2

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `iot_lights`
--

-- --------------------------------------------------------

--
-- Table structure for table `lights`
--

CREATE TABLE IF NOT EXISTS `lights` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `serial` varchar(20) NOT NULL,
  `device_eui` varchar(23) NOT NULL DEFAULT '00-00-00-00-00-00-00-00',
  `side_indicator` int(10) unsigned NOT NULL,
  `street_id` int(10) unsigned DEFAULT NULL,
  `intersection_id` int(10) unsigned DEFAULT NULL,
  `location` point NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `serial` (`serial`),
  KEY `street_id` (`street_id`),
  KEY `intersection_id` (`intersection_id`),
  SPATIAL KEY `location` (`location`),
  KEY `side_indicator` (`side_indicator`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=11 ;

--
-- Dumping data for table `lights`
--

INSERT INTO `lights` (`id`, `serial`, `device_eui`, `side_indicator`, `street_id`, `intersection_id`, `location`) VALUES
(1, 'garage-exit-north', '00-00-00-00-00-00-00-00', 1, 1, 4, '\0\0\0\0\0\0\0''"VM-[PC@'),
(2, 'garage-exit-south', '00-00-00-00-00-00-00-00', 2, 1, 4, '\0\0\0\0\0\0\0''"VM-[PC@'),
(3, 'garage-enter-north', '00-00-00-00-00-00-00-00', 1, 1, NULL, '\0\0\0\0\0\0\0sV>PC@'),
(4, 'garage-enter-south', '00-00-00-00-00-00-00-00', 2, 1, NULL, '\0\0\0\0\0\0\0sV>PC@'),
(5, 'bwy&locus-north', '00-00-00-00-00-00-00-00', 1, 1, 2, '\0\0\0\0\0\0\0"VFvPC@'),
(6, 'bwy&locus-south', '00-00-00-00-00-00-00-00', 2, 1, 2, '\0\0\0\0\0\0\0"VFvPC@'),
(7, 'shoe-repair-north', '00-00-00-00-00-00-00-00', 1, 1, NULL, '\0\0\0\0\0\0\0YQiVqhPC@'),
(8, 'shoe-repair-south', '00-00-00-00-00-00-00-00', 2, 1, NULL, '\0\0\0\0\0\0\0YQiVqhPC@'),
(9, 'chi-chi-north', '00-00-00-00-00-00-00-00', 1, 1, 3, '\0\0\0\0\0\0\0.V`\ZVq]PC@'),
(10, 'chi-chi-south', '00-00-00-00-00-00-00-00', 2, 1, 3, '\0\0\0\0\0\0\0.V`\ZVq]PC@');

-- --------------------------------------------------------

--
-- Table structure for table `lights_schedules`
--

CREATE TABLE IF NOT EXISTS `lights_schedules` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `light_id` int(10) unsigned NOT NULL,
  `schedule_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `schedule_id` (`schedule_id`),
  KEY `light_id` (`light_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=12 ;

--
-- Dumping data for table `lights_schedules`
--

INSERT INTO `lights_schedules` (`id`, `light_id`, `schedule_id`) VALUES
(3, 5, 66),
(4, 6, 66),
(5, 9, 66),
(6, 10, 66),
(7, 5, 70),
(8, 9, 70),
(9, 3, 70),
(10, 1, 70),
(11, 7, 70);

-- --------------------------------------------------------

--
-- Table structure for table `pole_sides`
--

CREATE TABLE IF NOT EXISTS `pole_sides` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `side` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `pole_sides`
--

INSERT INTO `pole_sides` (`id`, `side`) VALUES
(1, 'left'),
(2, 'right'),
(3, 'single');

-- --------------------------------------------------------

--
-- Table structure for table `repeat_by_options`
--

CREATE TABLE IF NOT EXISTS `repeat_by_options` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `repeat_by_options`
--

INSERT INTO `repeat_by_options` (`id`, `name`) VALUES
(1, 'day of the week'),
(2, 'day of the month');

-- --------------------------------------------------------

--
-- Table structure for table `repeat_types`
--

CREATE TABLE IF NOT EXISTS `repeat_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `repeat_types`
--

INSERT INTO `repeat_types` (`id`, `name`) VALUES
(1, 'Daily'),
(2, 'Weekly'),
(3, 'Monthly'),
(4, 'Yearly');

-- --------------------------------------------------------

--
-- Table structure for table `schedules`
--

CREATE TABLE IF NOT EXISTS `schedules` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `light_pwm` tinyint(3) unsigned DEFAULT NULL,
  `accent_pwm_red` tinyint(3) unsigned DEFAULT NULL,
  `accent_pwm_green` tinyint(3) unsigned DEFAULT NULL,
  `accent_pwm_blue` tinyint(3) unsigned DEFAULT NULL,
  `strobe` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` date NOT NULL,
  `start_time` time DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `repeat_type` int(10) unsigned DEFAULT NULL,
  `repeat_every` int(10) unsigned NOT NULL,
  `repeat_sunday` tinyint(1) NOT NULL DEFAULT '0',
  `repeat_monday` tinyint(1) NOT NULL DEFAULT '0',
  `repeat_tuesday` tinyint(1) NOT NULL DEFAULT '0',
  `repeat_wednesday` tinyint(1) NOT NULL DEFAULT '0',
  `repeat_thursday` tinyint(1) NOT NULL DEFAULT '0',
  `repeat_friday` tinyint(1) NOT NULL DEFAULT '0',
  `repeat_saturday` tinyint(1) NOT NULL DEFAULT '0',
  `repeat_by` int(10) unsigned DEFAULT NULL,
  `end_after_num` int(10) unsigned DEFAULT NULL,
  `end_on` date DEFAULT NULL,
  `is_template` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `repeat_type` (`repeat_type`),
  KEY `repeat_by` (`repeat_by`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=73 ;

--
-- Dumping data for table `schedules`
--

INSERT INTO `schedules` (`id`, `name`, `light_pwm`, `accent_pwm_red`, `accent_pwm_green`, `accent_pwm_blue`, `strobe`, `start_date`, `start_time`, `end_date`, `end_time`, `repeat_type`, `repeat_every`, `repeat_sunday`, `repeat_monday`, `repeat_tuesday`, `repeat_wednesday`, `repeat_thursday`, `repeat_friday`, `repeat_saturday`, `repeat_by`, `end_after_num`, `end_on`, `is_template`) VALUES
(1, 'Example Template', 200, 200, 0, 0, 1, '2016-04-01', '21:24:35', NULL, NULL, NULL, 3, 1, 0, 0, 0, 0, 0, 1, NULL, NULL, NULL, 1),
(46, 'All Fields', 192, 218, 139, 163, 0, '2016-04-19', '11:00:00', '2016-04-19', '12:00:00', 2, 1, 0, 1, 1, 0, 0, 0, 0, NULL, 1, NULL, 1),
(48, 'test', 192, 218, 139, 163, 0, '2016-04-19', '12:00:00', '2016-04-19', '01:00:00', 2, 1, 0, 1, 1, 0, 0, 0, 0, NULL, NULL, NULL, 1),
(66, 'First 4', 255, 0, 255, 0, 0, '2016-04-20', NULL, '2016-04-30', NULL, 2, 1, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, '2016-05-01', 0),
(67, 'First 4', 255, 0, 255, 0, 0, '2016-04-20', NULL, '2016-04-30', NULL, 2, 1, 1, 1, 0, 0, 0, 0, 0, NULL, NULL, '2016-05-01', 0),
(68, 'Odd side Red', 255, 255, 32, 80, 0, '2016-04-20', NULL, '2016-04-26', NULL, NULL, 1, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 1),
(69, 'Odd side Red', 255, 255, 32, 80, 0, '2016-04-20', NULL, '2016-04-26', NULL, NULL, 1, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 1),
(70, 'Odd accent Red', NULL, 255, 32, 80, 0, '2016-04-20', '11:00:00', '2016-04-26', '12:00:00', NULL, 1, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0),
(71, 'Odd accent Red', NULL, 255, 32, 80, 0, '2016-04-20', '11:00:00', '2016-04-26', '12:00:00', NULL, 1, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 0),
(72, 'Odd accent Red', NULL, NULL, NULL, NULL, 1, '2016-04-20', '11:00:00', '2016-04-26', '12:00:00', NULL, 1, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `streets`
--

CREATE TABLE IF NOT EXISTS `streets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `streets`
--

INSERT INTO `streets` (`id`, `name`) VALUES
(1, 'N Broadway'),
(2, 'Locust St'),
(3, 'Olive St'),
(4, 'St Charles St');

-- --------------------------------------------------------

--
-- Table structure for table `strobe_colors`
--

CREATE TABLE IF NOT EXISTS `strobe_colors` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `schedule_id` int(10) unsigned NOT NULL,
  `order_index` int(10) unsigned NOT NULL,
  `duration` smallint(5) unsigned NOT NULL,
  `accent_pwm_red` tinyint(3) unsigned DEFAULT NULL,
  `accent_pwm_green` tinyint(3) unsigned DEFAULT NULL,
  `accent_pwm_blue` tinyint(3) unsigned DEFAULT NULL,
  `rainbow` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `schedule_id_order` (`schedule_id`,`order_index`),
  KEY `schedule_id` (`schedule_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=40 ;

--
-- Dumping data for table `strobe_colors`
--

INSERT INTO `strobe_colors` (`id`, `schedule_id`, `order_index`, `duration`, `accent_pwm_red`, `accent_pwm_green`, `accent_pwm_blue`, `rainbow`) VALUES
(1, 1, 0, 1000, NULL, NULL, NULL, 1),
(2, 1, 1, 500, 150, 200, 0, 0),
(38, 72, 0, 3610, 255, 32, 80, 0),
(39, 72, 1, 3610, 0, 128, 0, 0);

--
-- Constraints for dumped tables
--

--
-- Constraints for table `lights`
--
ALTER TABLE `lights`
  ADD CONSTRAINT `lights_ibfk_1` FOREIGN KEY (`street_id`) REFERENCES `streets` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `lights_ibfk_2` FOREIGN KEY (`intersection_id`) REFERENCES `streets` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `lights_ibfk_3` FOREIGN KEY (`side_indicator`) REFERENCES `pole_sides` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `lights_schedules`
--
ALTER TABLE `lights_schedules`
  ADD CONSTRAINT `lights_schedules_ibfk_1` FOREIGN KEY (`light_id`) REFERENCES `lights` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `lights_schedules_ibfk_2` FOREIGN KEY (`schedule_id`) REFERENCES `schedules` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `schedules`
--
ALTER TABLE `schedules`
  ADD CONSTRAINT `schedules_ibfk_3` FOREIGN KEY (`repeat_type`) REFERENCES `repeat_types` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `schedules_ibfk_4` FOREIGN KEY (`repeat_by`) REFERENCES `repeat_by_options` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `strobe_colors`
--
ALTER TABLE `strobe_colors`
  ADD CONSTRAINT `strobe_colors_ibfk_2` FOREIGN KEY (`schedule_id`) REFERENCES `schedules` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
